#ifndef __PSPROPERTY__
#define __PSPROPERTY__

#include "pstypes.h"

enum PSProp
{
    PS_ShootingMode,    // shooting mode (read-only)
    PS_ImageSize,       // image size
    PS_JpegQuality,     // image quality
    PS_MeteringMode,    // metering mode
    PS_WBmode,          // white balance mode
    PS_FlashMode,       // flash mode
    PS_RedEyeMode,      // red-eye mode
    PS_ISOSpeed,        // ISO
    PS_Av,              // aperture
    PS_Tv,              // shutter speed
    PS_ExposureComp,    // exposure compensation
    PS_FlashComp,       // flash compensation
    PS_AFMode,          // autofocus mode
    PS_BatteryLevel,    // battery level (read-only)
    PS_FocusingZone,    // focusing zone
    PS_MyColors,        // my colors
    PS_Contrast,        // contrast
    PS_Sharpness,       // sharpness
    PS_Saturation,      // saturation
    PS_Red,             // red
    PS_Green,           // green
    PS_Blue,            // blue
    PS_SkinTone,        // skin tone
    PS_FlashPower,      // flash power
    PS_ManualFocusMode, // manual focus
};

// Additional information for property value
union PSProp_ValExtendedInfo
{
    struct // Additional information for PS_ImageSize property
    {
        int width;
        int height;
    } ImageSize;
};

// Property description
struct PSProp_Desc
{
    // list of values available for the property at the moment
    // in the exact order of values for the property as in property description
    int*                    availableValues;

    // list of additional information for property values in the same order as
    // in availableValues
    // If there is no additional information for value properties,
    // extendedValueInfo is a nullptr
    PSProp_ValExtendedInfo* extendedValueInfo;
    // length of availableValues list (and of extendedValueInfo list if it is
    // defined)
    int                     availableValuesLength;
    // read-only marker.  PS_TRUE for read-only properties and PS_FALSE for
    // read-write ones.
    int                     isReadOnly;
};

// [[ Properties

// Av
enum PSProp_Av
{
    PS_Av_1_8 = 18,        // 1.8
    PS_Av_2_0 = 20,        // 2.0
    PS_Av_2_2 = 22,        // 2.2
    PS_Av_2_5 = 25,        // 2.5
    PS_Av_2_7 = 27,        // 2.7
    PS_Av_2_8 = 28,        // 2.8
    PS_Av_3_2 = 32,        // 3.2
    PS_Av_3_4 = 34,        // 3.4
    PS_Av_3_5 = 35,        // 3.5
    PS_Av_4_0 = 40,        // 4.0
    PS_Av_4_5 = 45,        // 4.5
    PS_Av_5_0 = 50,        // 5.0
    PS_Av_5_6 = 56,        // 5.6
    PS_Av_6_3 = 63,        // 6.3
    PS_Av_7_1 = 71,        // 7.1
    PS_Av_8_0 = 80,        // 8.0
};

// Battery Level
enum PSProp_BatteryLevel
{
    PS_BatteryLevel_1,        // 1
    PS_BatteryLevel_2,        // 2
    PS_BatteryLevel_3,        // 3
    PS_BatteryLevel_4,        // 4
    PS_BatteryLevel_DC,        // DC
};

// Blue
enum PSProp_Blue
{
    PS_Blue_minus_2,        // -2
    PS_Blue_minus_1,        // -1
    PS_Blue_0,        // 0
    PS_Blue_1,        // 1
    PS_Blue_2,        // 2
};

// Contrast
enum PSProp_Contrast
{
    PS_Contrast_minus_2,        // -2
    PS_Contrast_minus_1,        // -1
    PS_Contrast_0,        // 0
    PS_Contrast_1,        // 1
    PS_Contrast_2,        // 2
};

// Exposure Compensation
enum PSProp_ExposureComp
{
    PS_ExposureComp_minus_3 = 500,        // -3
    PS_ExposureComp_minus_2_66 = 501,        // -2.66
    PS_ExposureComp_minus_2_33 = 502,        // -2.33
    PS_ExposureComp_minus_2 = 0,        // -2
    PS_ExposureComp_minus_1_66 = 34,        // -1.66
    PS_ExposureComp_minus_1_33 = 67,        // -1.33
    PS_ExposureComp_minus_1 = 100,        // -1
    PS_ExposureComp_minus_0_66 = 134,        // -0.66
    PS_ExposureComp_minus_0_33 = 167,        // -0.33
    PS_ExposureComp_0 = 200,        // 0
    PS_ExposureComp_plus_0_33 = 233,        // +0.33
    PS_ExposureComp_plus_0_66 = 266,        // +0.66
    PS_ExposureComp_plus_1 = 300,        // +1
    PS_ExposureComp_plus_1_33 = 333,        // +1.33
    PS_ExposureComp_plus_1_66 = 366,        // +1.66
    PS_ExposureComp_plus_2 = 400,        // +2
    PS_ExposureComp_plus_2_33 = 503,        // +2.33
    PS_ExposureComp_plus_2_66 = 504,        // +2.66
    PS_ExposureComp_plus_3 = 505,        // +3
};

// Flash Compensation
enum PSProp_FlashComp
{
    PS_FlashComp_minus_2 = 0,        // -2
    PS_FlashComp_minus_1_66 = 34,        // -1.66
    PS_FlashComp_minus_1_33 = 67,        // -1.33
    PS_FlashComp_minus_1 = 100,        // -1
    PS_FlashComp_minus_0_66 = 134,        // -0.66
    PS_FlashComp_minus_0_33 = 167,        // -0.33
    PS_FlashComp_0 = 200,        // 0
    PS_FlashComp_plus_0_33 = 233,        // +0.33
    PS_FlashComp_plus_0_66 = 266,        // +0.66
    PS_FlashComp_plus_1 = 300,        // +1
    PS_FlashComp_plus_1_33 = 333,        // +1.33
    PS_FlashComp_plus_1_66 = 366,        // +1.66
    PS_FlashComp_plus_2 = 400,        // +2
};

// Flash Mode
enum PSProp_FlashMode
{
    PS_FlashMode_Auto,        // Auto
    PS_FlashMode_On,        // On
    PS_FlashMode_Off,        // Off
};

// Flash Power
enum PSProp_FlashPower
{
    PS_FlashPower_Auto,        // Auto
    PS_FlashPower_Low,        // Low
    PS_FlashPower_Medium,        // Medium
    PS_FlashPower_High,        // High
};

// Focusing Zone
enum PSProp_FocusingZone
{
    PS_FocusingZone_Auto,        // Auto
    PS_FocusingZone_Normal,        // Normal
    PS_FocusingZone_Macro,        // Macro
    PS_FocusingZone_Super_Macro,        // Super Macro
    PS_FocusingZone_Infinity,        // Infinity
    PS_FocusingZone_Manual_Focus,        // Manual Focus
};

// Green
enum PSProp_Green
{
    PS_Green_minus_2,        // -2
    PS_Green_minus_1,        // -1
    PS_Green_0,        // 0
    PS_Green_1,        // 1
    PS_Green_2,        // 2
};

// ISO Speed
enum PSProp_ISOSpeed
{
    PS_ISOSpeed_Auto = 0,        // Auto
    PS_ISOSpeed_ISO_80 = 80,        // ISO 80
    PS_ISOSpeed_ISO_100 = 100,        // ISO 100
    PS_ISOSpeed_ISO_125 = 125,        // ISO 125
    PS_ISOSpeed_ISO_160 = 160,        // ISO 160
    PS_ISOSpeed_ISO_200 = 200,        // ISO 200
    PS_ISOSpeed_ISO_250 = 250,        // ISO 250
    PS_ISOSpeed_ISO_320 = 320,        // ISO 320
    PS_ISOSpeed_ISO_400 = 400,        // ISO 400
    PS_ISOSpeed_ISO_500 = 500,        // ISO 500
    PS_ISOSpeed_ISO_640 = 640,        // ISO 640
    PS_ISOSpeed_ISO_800 = 800,        // ISO 800
    PS_ISOSpeed_ISO_1000 = 1000,        // ISO 1000
    PS_ISOSpeed_ISO_1250 = 1250,        // ISO 1250
    PS_ISOSpeed_ISO_1600 = 1600,        // ISO 1600
    PS_ISOSpeed_ISO_2000 = 2000,        // ISO 2000
    PS_ISOSpeed_ISO_2500 = 2500,        // ISO 2500
    PS_ISOSpeed_ISO_3200 = 3200,        // ISO 3200
    PS_ISOSpeed_ISO_4000 = 4000,        // ISO 4000
    PS_ISOSpeed_ISO_5000 = 5000,        // ISO 5000
    PS_ISOSpeed_ISO_6400 = 6400,        // ISO 6400
    PS_ISOSpeed_ISO_8000 = 8000,        // ISO 8000
    PS_ISOSpeed_ISO_10000 = 10000,        // ISO 10000
    PS_ISOSpeed_ISO_12800 = 12800,        // ISO 12800
};

// Image Size
enum PSProp_ImageSize
{
    PS_ImageSize_Large,        // Large
    PS_ImageSize_Medium_1,        // Medium 1
    PS_ImageSize_Medium_2,        // Medium 2
    PS_ImageSize_Medium_3,        // Medium 3
    PS_ImageSize_Small,        // Small
    PS_ImageSize_Medium,        // Medium
};

// JPEG Quality
enum PSProp_JpegQuality
{
    PS_JpegQuality_Superfine,        // Superfine
    PS_JpegQuality_Fine,        // Fine
    PS_JpegQuality_Normal,        // Normal
    PS_JpegQuality_Normal_2,        // Normal 2
};

// Manual Focus Mode
enum PSProp_ManualFocusMode
{
    PS_ManualFocusMode_On,        // On
    PS_ManualFocusMode_Off,        // Off
};

// Metering Mode
enum PSProp_MeteringMode
{
    PS_MeteringMode_Evaluative,        // Evaluative
    PS_MeteringMode_Spot,        // Spot
    PS_MeteringMode_Center,        // Center
};

// My Colors
enum PSProp_MyColors
{
    PS_MyColors_Off,        // Off
    PS_MyColors_Vivid,        // Vivid
    PS_MyColors_Neutral,        // Neutral
    PS_MyColors_Sepia,        // Sepia
    PS_MyColors_BW,        // BW
    PS_MyColors_Positive_Film,        // Positive Film
    PS_MyColors_Lighter_Skin_Tone,        // Lighter Skin Tone
    PS_MyColors_Darker_Skin_Tone,        // Darker Skin Tone
    PS_MyColors_Vivid_Blue,        // Vivid Blue
    PS_MyColors_Vivid_Green,        // Vivid Green
    PS_MyColors_Vivid_Red,        // Vivid Red
    PS_MyColors_Custom_Color,        // Custom Color
    PS_MyColors_ColorSwap_Mode,        // ColorSwap Mode
    PS_MyColors_ColorAccent_Mode,        // ColorAccent Mode
};

// Red
enum PSProp_Red
{
    PS_Red_minus_2,        // -2
    PS_Red_minus_1,        // -1
    PS_Red_0,        // 0
    PS_Red_1,        // 1
    PS_Red_2,        // 2
};

// Red Eye Mode
enum PSProp_RedEyeMode
{
    PS_RedEyeMode_On,        // On
    PS_RedEyeMode_Off,        // Off
};

// Saturation
enum PSProp_Saturation
{
    PS_Saturation_minus_2,        // -2
    PS_Saturation_minus_1,        // -1
    PS_Saturation_0,        // 0
    PS_Saturation_1,        // 1
    PS_Saturation_2,        // 2
};

// Sharpness
enum PSProp_Sharpness
{
    PS_Sharpness_minus_2,        // -2
    PS_Sharpness_minus_1,        // -1
    PS_Sharpness_0,        // 0
    PS_Sharpness_1,        // 1
    PS_Sharpness_2,        // 2
};

// Shooting Mode
enum PSProp_ShootingMode
{
    PS_ShootingMode_Auto,        // Auto
    PS_ShootingMode_Program,        // Program
    PS_ShootingMode_Manual,        // Manual
    PS_ShootingMode_AV,        // AV
    PS_ShootingMode_TV,        // TV
    PS_ShootingMode_Easy,        // Easy
    PS_ShootingMode_Movie,        // Movie
    PS_ShootingMode_Discreet,        // Discreet
    PS_ShootingMode_LiveView,        // LiveView
    PS_ShootingMode_Portrait,        // Portrait
    PS_ShootingMode_FaceSelfTimer,        // FaceSelfTimer
    PS_ShootingMode_LowLight,        // LowLight
    PS_ShootingMode_FishEyeEffect,        // FishEyeEffect
    PS_ShootingMode_MiniatureEffect,        // MiniatureEffect
    PS_ShootingMode_ToyCameraEffect,        // ToyCameraEffect
    PS_ShootingMode_Monochrome,        // Monochrome
    PS_ShootingMode_SuperVivid,        // SuperVivid
    PS_ShootingMode_PosterEffect,        // PosterEffect
    PS_ShootingMode_Snow,        // Snow
    PS_ShootingMode_Fireworks,        // Fireworks
    PS_ShootingMode_LongShutter,        // LongShutter
    PS_ShootingMode_iFrameMovie,        // iFrameMovie
    PS_ShootingMode_DigitalIS,        // DigitalIS
    PS_ShootingMode_Landscape,        // Landscape
    PS_ShootingMode_SmartShutter,        // SmartShutter
    PS_ShootingMode_Beach,        // Beach
    PS_ShootingMode_Foliage,        // Foliage
    PS_ShootingMode_KidsAndPets,        // KidsAndPets
    PS_ShootingMode_ColorAccent,        // ColorAccent
    PS_ShootingMode_ColorSwap,        // ColorSwap
    PS_ShootingMode_Sports,        // Sports
    PS_ShootingMode_MovieDigest,        // MovieDigest
    PS_ShootingMode_HighSpeedBurstHQ,        // HighSpeedBurstHQ
    PS_ShootingMode_HandheldNightScene,        // HandheldNightScene
    PS_ShootingMode_StitchAssist,        // StitchAssist
    PS_ShootingMode_HighSpeedBurst,        // HighSpeedBurst
    PS_ShootingMode_BlurReduction,        // BlurReduction
    PS_ShootingMode_MovieMiniatureEffect,        // MovieMiniatureEffect
    PS_ShootingMode_MovieColorAccent,        // MovieColorAccent
    PS_ShootingMode_MovieColorSwap,        // MovieColorSwap
    PS_ShootingMode_Sunset,        // Sunset
    PS_ShootingMode_NightSnapshot,        // NightSnapshot
    PS_ShootingMode_Indoor,        // Indoor
    PS_ShootingMode_SuperSlowMotionMovie,        // SuperSlowMotionMovie
    PS_ShootingMode_SmoothSkin,        // SmoothSkin
    PS_ShootingMode_Underwater,        // Underwater
    PS_ShootingMode_HighDynamicRange,        // HighDynamicRange
    PS_ShootingMode_Nostalgic,        // Nostalgic
    PS_ShootingMode_SoftFocus,        // SoftFocus
};

// Skin Tone
enum PSProp_SkinTone
{
    PS_SkinTone_minus_2,        // -2
    PS_SkinTone_minus_1,        // -1
    PS_SkinTone_0,        // 0
    PS_SkinTone_1,        // 1
    PS_SkinTone_2,        // 2
};

// Tv
enum PSProp_Tv
{
    PS_Tv_15sec = 150000,        // 15"
    PS_Tv_13sec = 130000,        // 13"
    PS_Tv_10sec = 100000,        // 10"
    PS_Tv_8sec = 80000,        // 8"
    PS_Tv_6sec = 60000,        // 6"
    PS_Tv_5sec = 50000,        // 5"
    PS_Tv_4sec = 40000,        // 4"
    PS_Tv_3sec2 = 32000,        // 3"2
    PS_Tv_2sec5 = 25000,        // 2"5
    PS_Tv_2sec = 20000,        // 2"
    PS_Tv_1sec6 = 16000,        // 1"6
    PS_Tv_1sec3 = 13000,        // 1"3
    PS_Tv_1sec = 10000,        // 1"
    PS_Tv_0sec8 = 8000,        // 0"8
    PS_Tv_0sec6 = 6000,        // 0"6
    PS_Tv_0sec5 = 5000,        // 0"5
    PS_Tv_0sec4 = 4000,        // 0"4
    PS_Tv_0sec3 = 3000,        // 0"3
    PS_Tv_4 = 2500,        // 1/4
    PS_Tv_5 = 2000,        // 1/5
    PS_Tv_6 = 1666,        // 1/6
    PS_Tv_8 = 1250,        // 1/8
    PS_Tv_10 = 1000,        // 1/10
    PS_Tv_13 = 769,        // 1/13
    PS_Tv_15 = 666,        // 1/15
    PS_Tv_20 = 500,        // 1/20
    PS_Tv_25 = 400,        // 1/25
    PS_Tv_30 = 333,        // 1/30
    PS_Tv_40 = 250,        // 1/40
    PS_Tv_50 = 200,        // 1/50
    PS_Tv_60 = 166,        // 1/60
    PS_Tv_80 = 125,        // 1/80
    PS_Tv_100 = 100,        // 1/100
    PS_Tv_125 = 80,        // 1/125
    PS_Tv_160 = 62,        // 1/160
    PS_Tv_200 = 50,        // 1/200
    PS_Tv_250 = 40,        // 1/250
    PS_Tv_320 = 31,        // 1/320
    PS_Tv_400 = 25,        // 1/400
    PS_Tv_500 = 20,        // 1/500
    PS_Tv_640 = 15,        // 1/640
    PS_Tv_800 = 12,        // 1/800
    PS_Tv_1000 = 10,        // 1/1000
    PS_Tv_1250 = 8,        // 1/1250
    PS_Tv_1600 = 6,        // 1/1600
    PS_Tv_2000 = 5,        // 1/2000
    PS_Tv_2500 = 4,        // 1/2500
    PS_Tv_3200 = 2,        // 1/3200
    PS_Tv_4000 = 1,        // 1/4000
};

// WB Mode
enum PSProp_WBmode
{
    PS_WBmode_Auto,        // Auto
    PS_WBmode_Day_Light,        // Day Light
    PS_WBmode_Cloudy,        // Cloudy
    PS_WBmode_Tungsten,        // Tungsten
    PS_WBmode_Fluorescent,        // Fluorescent
    PS_WBmode_Fluorescent_H,        // Fluorescent H
    PS_WBmode_Custom,        // Custom
    PS_WBmode_Flash,        // Flash
    PS_WBmode_Underwater,        // Underwater
    PS_WBmode_Custom_1,        // Custom 1
    PS_WBmode_Custom_2,        // Custom 2
};

// ]] Properties

#endif // __PSPROPERTY__
