#ifndef __PSTYPES__
#define __PSTYPES__

enum 
PSResult
{
    // Function finished successfully
    PS_OK = 0,
    // Function failed due to unspecified reason
    PS_FAILED = 1,
    // Attempt to open new connection session with the camera has finished unsuccessfully 
    // because there is already a session established with the camera
    PS_SESSION_ALREADY_OPENED = 2,
    // Attempt to send a command to the camera (or establish connection with the camera) was unsuccessful 
    // because camera wasnt found
    PS_CAMERA_NOT_FOUND = 3,
    // Command hasnt returned processing result because it is not ready yet
    PS_RESULT_NOT_READY = 4,
    // Attempt to get or set certain camera property has been failed, 
    // because such property is not available for the camera
    PS_UNSUPPORTED_PROPERTY = 6,
    // Attempt to set certain value for the property has been failed 
    // because the value is not supported by the property
    PS_UNSUPPORTED_PROPERTY_VALUE = 7,
    // Battery level too low to operate
    PS_LOW_BATTERY_LEVEL = 8,
    // Camera was disconnected
    PS_CAMERA_DISCONNECTED = 9,
    // PSSDK already running
    PS_PSSDK_ALREADY_RUNNING = 10,
    // Activation server unavailable
    PS_ACTIVATION_SERVER_UNAVAILABLE = 11,
    // License serial number is invalid
    PS_INVALID_SERIAL_NUMBER = 12,
    // Old PS module version
    PS_OLD_PSM_VERSION = 13,
};

enum
PSBool
{
    PS_FALSE,
    PS_TRUE
};

#define PS_MAX_FILE_NAME_LEN    128

// identifier of file in file list stored on camera's flash memory card
typedef int PSFileId;

// file information
struct
PSFileInfo
{
    // unique file identifier
    PSFileId    id;
    // filename
    wchar_t     name[PS_MAX_FILE_NAME_LEN];
    // file size in bytes
    int         size;
};

#define PSSTDCALL __stdcall
#define PSEXPORT __declspec(dllexport)
#define PSIMPORT __declspec(dllimport)

#ifdef PSSDK_EXPORTS
#define PSSDKAPI PSEXPORT PSSTDCALL
#else
#define PSSDKAPI PSIMPORT PSSTDCALL
#endif

#endif // __PSTYPES__
