
// mfc_twain_exampleDlg.cpp : implementation file
//

#include "pch.h"
#include "framework.h"
#include "mfc_twain_example.h"
#include "mfc_twain_exampleDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CmfctwainexampleDlg dialog



CmfctwainexampleDlg::CmfctwainexampleDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_MFC_TWAIN_EXAMPLE_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CmfctwainexampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CmfctwainexampleDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDScan, &CmfctwainexampleDlg::OnBnClickedScan)
	ON_WM_DESTROY()
	ON_WM_TIMER()
END_MESSAGE_MAP()


// CmfctwainexampleDlg message handlers

BOOL CmfctwainexampleDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	SetTimer(IDT_DS_READY_TIMER, 100, nullptr);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CmfctwainexampleDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CmfctwainexampleDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CmfctwainexampleDlg::OnBnClickedScan()
{
	// TODO: It is necessary to save the graphic file to the folder for file 
	// transfer (file_transfer_path in the configuration file). 
	// Only after this should ReleaseSemaphore be called.

	HANDLE sem = OpenSemaphore(SEMAPHORE_MODIFY_STATE, FALSE, _T("twain_file_ready_sem"));

	if (sem) {
		ReleaseSemaphore(sem, 1, NULL);
		CloseHandle(sem);

		EndDialog(IDOK);
	}
	else {
		AfxMessageBox(_T("Error: The semaphore \"twain_file_ready_sem\" does not exist."));
	}
}

void CmfctwainexampleDlg::OnDestroy()
{
    KillTimer(IDT_DS_READY_TIMER);

	HANDLE sem = OpenSemaphore(SEMAPHORE_MODIFY_STATE, FALSE, _T("twain_stop_sem"));

	if (sem) {
		ReleaseSemaphore(sem, 1, NULL);
		CloseHandle(sem);
	}

    CDialogEx::OnDestroy();
}

void CmfctwainexampleDlg::OnTimer(UINT_PTR nIDEvent)
{
    if (nIDEvent == IDT_DS_READY_TIMER)
    {
		HANDLE sem = OpenSemaphore(SEMAPHORE_MODIFY_STATE, FALSE, _T("twain_ds_ready_sem"));
		if (sem == NULL) {
			GetDlgItem(IDScan)->EnableWindow(FALSE);
		}
		else {
			GetDlgItem(IDScan)->EnableWindow(TRUE);
			CloseHandle(sem);
		}
    }
    CDialogEx::OnTimer(nIDEvent);
}
